/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.performance;

import com.sun.management.ThreadMXBean;
import com.teamscale.core.runtime.impl.performance.IThreadMemoryMonitor;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.concurrent.ThreadUtils;

public class ThreadMemoryMonitor
extends Thread
implements IThreadMemoryMonitor {
    private final ThreadMXBean threadMxBean;
    private final Map<Long, Long> maxMemoryBytesByThreadId = new HashMap<Long, Long>();
    private final long monitoringIntervalMilliSeconds;

    public ThreadMemoryMonitor(long monitoringIntervalMilliSeconds) throws UnsupportedOperationException {
        this.monitoringIntervalMilliSeconds = monitoringIntervalMilliSeconds;
        java.lang.management.ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        if (!(threadMxBean instanceof ThreadMXBean) || !((ThreadMXBean)threadMxBean).isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException("Thread memory monitoring is not supported!");
        }
        this.threadMxBean = (ThreadMXBean)threadMxBean;
        if (!this.threadMxBean.isThreadAllocatedMemoryEnabled()) {
            this.threadMxBean.setThreadAllocatedMemoryEnabled(true);
        }
        this.setDaemon(true);
        this.setName("Memory monitoring thread");
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            this.updateThreadMemory();
            ThreadUtils.sleep((long)this.monitoringIntervalMilliSeconds);
        }
    }

    private synchronized void updateThreadMemory() {
        long[] ids = this.maxMemoryBytesByThreadId.keySet().stream().mapToLong(x -> x).toArray();
        long[] memory = this.threadMxBean.getThreadAllocatedBytes(ids);
        for (int i = 0; i < ids.length; ++i) {
            this.maxMemoryBytesByThreadId.merge(ids[i], memory[i], Math::max);
        }
    }

    @Override
    public synchronized void startRecording(long threadId) {
        this.maxMemoryBytesByThreadId.put(threadId, 0L);
    }

    @Override
    public synchronized long getMaxMemoryBytes(long threadId) {
        return this.maxMemoryBytesByThreadId.getOrDefault(threadId, 0L);
    }
}

