/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.progress;

import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateBase;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class BranchAnalysisStateWithDebugInfo
extends BranchAnalysisStateBase<SetMap<String, String>> {
    private static final long serialVersionUID = 1L;
    private final SortedMap<Long, SetMap<String, String>> writtenStoresByTimestamp = new TreeMap<Long, SetMap<String, String>>();

    @Override
    public SortedMap<Long, SetMap<String, String>> getWrittenStoresByTimestamp() {
        return this.writtenStoresByTimestamp;
    }

    @Override
    public boolean updateWrittenStores(long timestamp, Set<String> writeStores, ScheduledJob nextJob) {
        SetMap writtenStoresToWritingTriggers = this.writtenStoresByTimestamp.computeIfAbsent(timestamp, x -> new SetMap());
        boolean changed = false;
        for (String writeStore : writeStores) {
            changed |= writtenStoresToWritingTriggers.add((Object)writeStore, (Object)nextJob.getTriggerName());
        }
        return changed;
    }

    @Override
    public Optional<ProjectAnalysisProgress.ConflictInfo> getConflictInfo(CommitDescriptor schedulingCommit, Set<String> transitiveWriteStores, boolean isPrivilegedTrigger, @Nullable UUID rollbackId, long maximumAllowedWriteBoundary) {
        ProjectAnalysisProgress.ConflictInfo completionBoundaryConflict = this.getConflictWithCompletionBoundaryByStore(schedulingCommit, transitiveWriteStores, rollbackId, maximumAllowedWriteBoundary);
        if (completionBoundaryConflict != null) {
            return Optional.of(completionBoundaryConflict);
        }
        for (long writtenTimestamp : this.writtenStoresByTimestamp.keySet()) {
            boolean hasWriteOverlap;
            SetMap writtenStores = (SetMap)this.writtenStoresByTimestamp.get(writtenTimestamp);
            HashSet writeIntersection = CollectionUtils.intersectionSet((Collection)writtenStores.getKeys(), (Collection[])new Collection[]{transitiveWriteStores});
            boolean bl = hasWriteOverlap = isPrivilegedTrigger || !writeIntersection.isEmpty();
            if (maximumAllowedWriteBoundary >= writtenTimestamp || !hasWriteOverlap) continue;
            String conflictDetails = BranchAnalysisStateWithDebugInfo.createConflictDetailsMessage(isPrivilegedTrigger, (SetMap<String, String>)writtenStores, writeIntersection);
            return Optional.of(new ProjectAnalysisProgress.ConflictInfo(new CommitDescriptor(schedulingCommit.getBranchName(), writtenTimestamp), conflictDetails, rollbackId));
        }
        return Optional.empty();
    }

    private static @NonNull String createConflictDetailsMessage(boolean isPrivilegedTrigger, SetMap<String, String> writtenStores, Set<String> writeIntersection) {
        StringBuilder conflictDetails;
        if (isPrivilegedTrigger) {
            conflictDetails = new StringBuilder("Conflict due to privileged trigger.");
        } else {
            conflictDetails = new StringBuilder("Conflict due to write overlap: [");
            for (String intersection : writeIntersection) {
                conflictDetails.append("\n\t").append(intersection).append(":");
                Set conflictingTriggers = (Set)writtenStores.getCollection((Object)intersection);
                for (String trigger : conflictingTriggers) {
                    conflictDetails.append("\n\t\t").append(trigger).append(";");
                }
            }
            conflictDetails.append("\n]");
        }
        return conflictDetails.toString();
    }
}

