/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.project;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.util.StorageUtils;

public class CopyProjectDataTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void execute() throws ConQATException {
        InternalProjectId fromProjectId = this.jobDescriptor.getInternalProjectId();
        InternalProjectId toProjectId = new InternalProjectId(this.jobDescriptor.getParameter());
        IStorageSystemProvider rawStorageSystemProvider = this.indexLayer.getRawStorageSystemProvider();
        IStorageSystem fromProjectPartition = rawStorageSystemProvider.openStorageSystem(fromProjectId);
        IStorageSystem toProjectPartition = rawStorageSystemProvider.openStorageSystem(toProjectId);
        IndexSchema fromIndexSchema = IndexSchema.load((IStorageSystem)fromProjectPartition, (SynchronizedCacheAccess)IndexSchemaCache.UNCACHED_ACCESS);
        IndexSchema toIndexSchema = IndexSchema.load((IStorageSystem)toProjectPartition, (SynchronizedCacheAccess)IndexSchemaCache.UNCACHED_ACCESS);
        for (String storeName : fromIndexSchema.getEntryNames()) {
            if (!fromIndexSchema.isStoreUsingOption(storeName, EStorageOption.BACKUP)) continue;
            if (toIndexSchema.getEntry(storeName) != null) {
                StorageUtils.copyStore((IStore)fromProjectPartition.openStore(storeName), (IStore)toProjectPartition.openStore(storeName));
                continue;
            }
            LOGGER.warn("Ignored store " + storeName + " during copying data from project " + String.valueOf(fromProjectId) + " to project " + String.valueOf(toProjectId));
        }
        ProjectSchedulingFilter.resumeProjectIfPaused(toProjectId, this.indexLayer.openGlobalStorageSystem());
        ProjectIndex projectIndex = this.indexLayer.openGlobalIndex(ProjectIndex.class);
        ProjectInfo toProject = projectIndex.getProjectWithoutPublicIdResolution(toProjectId).orElseThrow();
        toProject.setCopyingData(false);
        projectIndex.setProject(toProject);
    }

    @Override
    public int getExecutionOrderIndex() {
        return -2;
    }

    @Override
    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.PRIORITY_FULLY_ISOLATED;
    }
}

