/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.google.common.collect.Streams;
import com.microsoft.tfs.core.clients.webservices.GroupWellKnownSIDConstants;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.IdentitySearchFactor;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.tfs.ITfsIdentityClient;
import com.teamscale.core.tfs.TfsException;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

class TfsIdentityClient
implements ITfsIdentityClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIdentityManagementService2 service;

    TfsIdentityClient(IIdentityManagementService2 service) {
        this.service = service;
    }

    @Override
    public Set<String> retrieveAllGroupNames() throws TfsException {
        TeamFoundationIdentity rootIdentity = this.findIdentityBySid(GroupWellKnownSIDConstants.EVERYONE_GROUP_SID).orElseThrow(() -> new TfsException("Unable to retrieve all group names from the TFS server via the group identifier."));
        IdentityDescriptor[] groupDescriptors = (IdentityDescriptor[])Arrays.stream(rootIdentity.getMembers()).filter(c -> "Microsoft.TeamFoundation.Identity".equals(c.getIdentityType())).toArray(IdentityDescriptor[]::new);
        TeamFoundationIdentity[] groupIdentities = this.getIdentitiesForDescriptors(groupDescriptors);
        return Stream.concat(Stream.of(rootIdentity), Arrays.stream(groupIdentities)).filter(TeamFoundationIdentity::isContainer).map(TeamFoundationIdentity::getDisplayName).collect(Collectors.toSet());
    }

    @Override
    public Set<UserGroup> getGroupsByName(String serverName, String groupName) {
        Set<TeamFoundationIdentity> identities = this.queryIdentitiesWhereFieldIsValue(IdentitySearchFactor.DISPLAY_NAME, MembershipQuery.NONE, groupName);
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        for (TeamFoundationIdentity identity : identities) {
            if (!identity.isContainer()) continue;
            groups.add(this.toUserGroup(identity, serverName));
        }
        return groups;
    }

    @Override
    public Optional<UserGroup> getGroupByIdentifier(String serverName, String groupIdentifier) {
        Optional<TeamFoundationIdentity> identity = this.queryIdentityWhereFieldIsValue(IdentitySearchFactor.IDENTIFIER, MembershipQuery.EXPANDED, groupIdentifier).filter(TeamFoundationIdentity::isContainer);
        if (identity.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.toUserGroup(identity.get(), serverName));
    }

    private UserGroup toUserGroup(TeamFoundationIdentity identity, String serverName) {
        CCSMAssert.isTrue((boolean)identity.isContainer(), (String)"Failed to convert non-container TFS identity to a UserGroup.");
        UserGroup group = new UserGroup(identity.getDisplayName(), EAuthenticationTool.TFS, identity.getDescriptor().getIdentifier(), serverName);
        return this.withAddedMembers(group, identity.getMembers());
    }

    @Override
    public Set<UserGroup> getGroupsByUser(String serverName, User user) throws AuthenticationEntityNotFoundException {
        TeamFoundationIdentity userIdentity = this.getIdentityFromUser(user).orElseThrow(() -> new AuthenticationEntityNotFoundException("User '%s' not found!".formatted(user.getUsername())));
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        for (TeamFoundationIdentity identity : this.getIdentitiesForDescriptors(userIdentity.getMemberOf())) {
            if (!identity.isContainer()) continue;
            groups.add(this.toUserGroup(identity, serverName));
        }
        return groups;
    }

    private UserGroup withAddedMembers(UserGroup group, IdentityDescriptor ... descriptors) {
        TeamFoundationIdentity[] identities = this.getIdentitiesForDescriptors(descriptors);
        group.addUserNames(Arrays.stream(identities).map(TeamFoundationIdentity::getUniqueName).collect(Collectors.toSet()));
        return group;
    }

    @Override
    public Set<String> getUserIdsByGroup(UserGroup group, @Nullable String userIdAttributeName) throws AuthenticationEntityNotFoundException {
        String remoteGroupIdentifier = group.getRemoteGroup();
        Optional<TeamFoundationIdentity> tfsGroup = this.findIdentityBySid(remoteGroupIdentifier);
        if (tfsGroup.isEmpty()) {
            throw new AuthenticationEntityNotFoundException("Group with the remote identifier '%s' was not found on the TFS server.".formatted(group.getRemoteGroup()));
        }
        return Arrays.stream(this.getIdentitiesForDescriptors(tfsGroup.get().getMembers())).filter(identity -> !identity.isContainer()).map(identity -> TfsIdentityClient.getQueryableAuthorizationUserId(identity, userIdAttributeName)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Set<TeamFoundationIdentity> queryIdentitiesWhereFieldIsValue(IdentitySearchFactor field, MembershipQuery membershipQuery, String ... acceptedValues) {
        return Arrays.stream(this.service.readIdentities(field, acceptedValues, membershipQuery, ReadIdentityOptions.NONE)).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    private Optional<TeamFoundationIdentity> queryIdentityWhereFieldIsValue(IdentitySearchFactor field, MembershipQuery membershipQuery, String acceptedValue) {
        return Optional.ofNullable(this.service.readIdentity(field, acceptedValue, membershipQuery, ReadIdentityOptions.NONE));
    }

    private static Optional<String> getQueryableAuthorizationUserId(TeamFoundationIdentity identity, @Nullable String userIdAttributeName) {
        Optional<String> userId;
        if (!StringUtils.isEmpty((String)userIdAttributeName)) {
            CaseInsensitiveStringSet propertyNames = new CaseInsensitiveStringSet();
            Streams.stream((Iterable)identity.getProperties()).forEach(entry -> propertyNames.add((String)entry.getKey()));
            return TfsIdentityClient.getIdentityProperty(identity, propertyNames.get(userIdAttributeName));
        }
        if ("System.Security.Principal.WindowsIdentity".equals(identity.getDescriptor().getIdentityType()) && (userId = TfsIdentityClient.getIdentityProperty(identity, "DN")).isPresent()) {
            return userId;
        }
        userId = TfsIdentityClient.getIdentityProperty(identity, "Mail");
        if (userId.isPresent()) {
            return userId;
        }
        return Optional.of(identity.getUniqueName());
    }

    private static Optional<String> getIdentityProperty(TeamFoundationIdentity identity, String name) {
        Object property = identity.getProperty(name);
        if (property != null && !(property instanceof String)) {
            LOGGER.warn("Received a non-string property value for '{}', ignoring: '{}'", (Object)name, property);
            return Optional.empty();
        }
        return Optional.ofNullable((String)property).filter(value -> !StringUtils.isEmpty((String)value));
    }

    private Optional<TeamFoundationIdentity> getIdentityFromUser(User user) {
        Optional<TeamFoundationIdentity> userIdentity = this.queryIdentityWhereFieldIsValue(IdentitySearchFactor.ACCOUNT_NAME, MembershipQuery.EXPANDED, user.getUsername());
        if (userIdentity.isEmpty() && user.getUsername().contains("@")) {
            userIdentity = this.queryIdentityWhereFieldIsValue(IdentitySearchFactor.MAIL_ADDRESS, MembershipQuery.EXPANDED, user.getUsername());
        }
        if (userIdentity.isEmpty() && !StringUtils.isEmpty((String)user.getEmailAddress())) {
            userIdentity = this.queryIdentityWhereFieldIsValue(IdentitySearchFactor.ACCOUNT_NAME, MembershipQuery.EXPANDED, user.getUsername());
        }
        return userIdentity;
    }

    private TeamFoundationIdentity[] getIdentitiesForDescriptors(IdentityDescriptor[] descriptors) {
        return this.service.readIdentities(descriptors, MembershipQuery.NONE, ReadIdentityOptions.NONE, new String[0], IdentityPropertyScope.NONE);
    }

    private Optional<TeamFoundationIdentity> findIdentityBySid(String groupSid) {
        return this.queryIdentityWhereFieldIsValue(IdentitySearchFactor.IDENTIFIER, MembershipQuery.EXPANDED, groupSid);
    }
}

