/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import java.io.Serializable;
import java.time.LocalDate;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@Index(name="user-satisfaction-status", options={EStorageOption.BACKUP, EStorageOption.COMPRESSED})
public class UserSatisfactionStatusIndex
implements IGlobalIndex {
    private static final int INITIAL_PROMPT_INTERVAL_DAYS = 90;
    private static final int RE_PROMPT_INTERVAL_DAYS = 180;
    private final ValueIndex<UserSatisfactionStatus> delegate;

    public UserSatisfactionStatusIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setUserSatisfactionStatus(String username, EUserSatisfactionStatus status, LocalDate date) throws StorageException {
        this.delegate.setValue(username, (Object)new UserSatisfactionStatus(status, date));
    }

    public @Nullable UserSatisfactionStatus getUserSatisfactionStatus(String username) throws StorageException {
        return (UserSatisfactionStatus)this.delegate.getValue(username);
    }

    public boolean shouldPromptUserForFeedback(String username) throws StorageException {
        UserSatisfactionStatus userSatisfactionStatus = this.getUserSatisfactionStatus(username);
        if (userSatisfactionStatus == null) {
            this.setUserSatisfactionStatus(username, EUserSatisfactionStatus.ASK_LATER, DateTimeUtils.zonedNow().toLocalDate());
            return false;
        }
        if (!EFeatureToggle.ENABLE_CUSTOMER_SATISFACTION_DIALOG.isEnabled()) {
            return false;
        }
        return switch (userSatisfactionStatus.status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> false;
            case 1 -> UserSatisfactionStatusIndex.shouldPromptUserForFeedback(userSatisfactionStatus.date, 90);
            case 0 -> UserSatisfactionStatusIndex.shouldPromptUserForFeedback(userSatisfactionStatus.date, 180);
        };
    }

    private static boolean shouldPromptUserForFeedback(LocalDate lastPromptedDate, int promptIntervalDay) {
        return DateTimeUtils.zonedNow().toLocalDate().isAfter(lastPromptedDate.plusDays(promptIntervalDay));
    }

    public void removeUserSatisfactionStatus(String username) throws StorageException {
        this.delegate.removeValue(username);
    }

    @IndexValueClass(containedInBackup=true)
    public record UserSatisfactionStatus(EUserSatisfactionStatus status, LocalDate date) implements Serializable
    {
    }

    @IndexValueClass(containedInBackup=true)
    public static enum EUserSatisfactionStatus {
        SUBMITTED,
        ASK_LATER,
        DISMISSED;

    }
}

