/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import com.teamscale.core.index.CommitDescriptorIndex;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CommitDescriptorUtils {
    public static Optional<ParentedCommitDescriptor> guessCorrespondingCodeCommit(CommitDescriptor nonCodeCommit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        long guessedCodeCommitTimestamp = CommitDescriptorUtils.floorToSecond(nonCodeCommit);
        CommitDescriptor potentialCodeCommitDescriptor = new CommitDescriptor(nonCodeCommit.getBranchName(), guessedCodeCommitTimestamp);
        return Optional.ofNullable(commitDescriptorIndex.getCommit(potentialCodeCommitDescriptor));
    }

    private static long floorToSecond(CommitDescriptor nonCodeCommit) {
        return nonCodeCommit.getTimestamp() - nonCodeCommit.getTimestamp() % 1000L;
    }

    private CommitDescriptorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

