/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.rocksdb.CompressionType;
import org.rocksdb.MutableOptionKey;
import org.rocksdb.MutableOptionValue;
import org.rocksdb.OptionString;
import org.rocksdb.PrepopulateBlobCache;

public abstract class AbstractMutableOptions {
    protected static final String KEY_VALUE_PAIR_SEPARATOR = ";";
    protected static final char KEY_VALUE_SEPARATOR = '=';
    static final String INT_ARRAY_INT_SEPARATOR = ":";
    protected final String[] keys;
    private final String[] values;

    protected AbstractMutableOptions(String[] keys, String[] values) {
        this.keys = keys;
        this.values = values;
    }

    String[] getKeys() {
        return this.keys;
    }

    String[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.keys.length; ++i) {
            buffer.append(this.keys[i]).append('=').append(this.values[i]);
            if (i + 1 >= this.keys.length) continue;
            buffer.append(KEY_VALUE_PAIR_SEPARATOR);
        }
        return buffer.toString();
    }

    public static abstract class AbstractMutableOptionsBuilder<T extends AbstractMutableOptions, U extends AbstractMutableOptionsBuilder<T, U, K>, K extends MutableOptionKey> {
        private final Map<K, MutableOptionValue<?>> options = new LinkedHashMap();
        private final List<OptionString.Entry> unknown = new ArrayList<OptionString.Entry>();

        protected abstract U self();

        protected abstract Map<String, K> allKeys();

        protected abstract T build(String[] var1, String[] var2);

        public T build() {
            String[] keys = new String[this.options.size()];
            String[] values = new String[this.options.size()];
            int i = 0;
            for (Map.Entry<K, MutableOptionValue<?>> option : this.options.entrySet()) {
                keys[i] = ((MutableOptionKey)option.getKey()).name();
                values[i] = option.getValue().asString();
                ++i;
            }
            return this.build(keys, values);
        }

        protected U setDouble(K key, double value) {
            if (key.getValueType() != MutableOptionKey.ValueType.DOUBLE) {
                throw new IllegalArgumentException(key + " does not accept a double value");
            }
            this.options.put(key, MutableOptionValue.fromDouble(value));
            return this.self();
        }

        protected double getDouble(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asDouble();
        }

        protected U setLong(K key, long value) {
            if (key.getValueType() != MutableOptionKey.ValueType.LONG) {
                throw new IllegalArgumentException(key + " does not accept a long value");
            }
            this.options.put(key, MutableOptionValue.fromLong(value));
            return this.self();
        }

        protected long getLong(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asLong();
        }

        protected U setInt(K key, int value) {
            if (key.getValueType() != MutableOptionKey.ValueType.INT) {
                throw new IllegalArgumentException(key + " does not accept an integer value");
            }
            this.options.put(key, MutableOptionValue.fromInt(value));
            return this.self();
        }

        protected int getInt(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asInt();
        }

        protected U setBoolean(K key, boolean value) {
            if (key.getValueType() != MutableOptionKey.ValueType.BOOLEAN) {
                throw new IllegalArgumentException(key + " does not accept a boolean value");
            }
            this.options.put(key, MutableOptionValue.fromBoolean(value));
            return this.self();
        }

        protected boolean getBoolean(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asBoolean();
        }

        protected U setIntArray(K key, int[] value) {
            if (key.getValueType() != MutableOptionKey.ValueType.INT_ARRAY) {
                throw new IllegalArgumentException(key + " does not accept an int array value");
            }
            this.options.put(key, MutableOptionValue.fromIntArray(value));
            return this.self();
        }

        protected int[] getIntArray(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asIntArray();
        }

        protected <N extends Enum<N>> U setEnum(K key, N value) {
            if (key.getValueType() != MutableOptionKey.ValueType.ENUM) {
                throw new IllegalArgumentException(key + " does not accept a Enum value");
            }
            this.options.put(key, MutableOptionValue.fromEnum(value));
            return this.self();
        }

        protected <N extends Enum<N>> N getEnum(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            if (!(value instanceof MutableOptionValue.MutableOptionEnumValue)) {
                throw new NoSuchElementException(key.name() + " is not of Enum type");
            }
            return (N)((Enum)((MutableOptionValue.MutableOptionEnumValue)value).asObject());
        }

        private long parseAsLong(String value) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                double doubleValue = Double.parseDouble(value);
                if (doubleValue != (double)Math.round(doubleValue)) {
                    throw new IllegalArgumentException("Unable to parse or round " + value + " to long");
                }
                return Math.round(doubleValue);
            }
        }

        private int parseAsInt(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                double doubleValue = Double.parseDouble(value);
                if (doubleValue != (double)Math.round(doubleValue)) {
                    throw new IllegalArgumentException("Unable to parse or round " + value + " to int");
                }
                return (int)Math.round(doubleValue);
            }
        }

        protected U fromParsed(List<OptionString.Entry> options, boolean ignoreUnknown) {
            Objects.requireNonNull(options);
            for (OptionString.Entry option : options) {
                try {
                    if (option.key.isEmpty()) {
                        throw new IllegalArgumentException("options string is invalid: " + option);
                    }
                    this.fromOptionString(option, ignoreUnknown);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("" + option.key + "=" + option.value + " - not a valid value for its type", nfe);
                }
            }
            return this.self();
        }

        private U fromOptionString(OptionString.Entry option, boolean ignoreUnknown) throws IllegalArgumentException {
            Objects.requireNonNull(option.key);
            Objects.requireNonNull(option.value);
            MutableOptionKey key = (MutableOptionKey)this.allKeys().get(option.key);
            if (key == null && ignoreUnknown) {
                this.unknown.add(option);
                return this.self();
            }
            if (key == null) {
                throw new IllegalArgumentException("Key: " + null + " is not a known option key");
            }
            if (!option.value.isList()) {
                throw new IllegalArgumentException("Option: " + key + " is not a simple value or list, don't know how to parse it");
            }
            if (key.getValueType() != MutableOptionKey.ValueType.INT_ARRAY && option.value.list.size() != 1) {
                throw new IllegalArgumentException("Simple value does not have exactly 1 item: " + option.value.list);
            }
            List<String> valueStrs = option.value.list;
            String valueStr = valueStrs.get(0);
            switch (key.getValueType()) {
                case DOUBLE: {
                    return this.setDouble(key, Double.parseDouble(valueStr));
                }
                case LONG: {
                    return this.setLong(key, this.parseAsLong(valueStr));
                }
                case INT: {
                    return this.setInt(key, this.parseAsInt(valueStr));
                }
                case BOOLEAN: {
                    return this.setBoolean(key, Boolean.parseBoolean(valueStr));
                }
                case INT_ARRAY: {
                    int[] value = new int[valueStrs.size()];
                    for (int i = 0; i < valueStrs.size(); ++i) {
                        value[i] = Integer.parseInt(valueStrs.get(i));
                    }
                    return this.setIntArray(key, value);
                }
                case ENUM: {
                    String optionName = key.name();
                    if (optionName.equals("prepopulate_blob_cache")) {
                        PrepopulateBlobCache prepopulateBlobCache = PrepopulateBlobCache.getFromInternal(valueStr);
                        return this.setEnum(key, prepopulateBlobCache);
                    }
                    if (optionName.equals("compression") || optionName.equals("blob_compression_type")) {
                        CompressionType compressionType = CompressionType.getFromInternal(valueStr);
                        return this.setEnum(key, compressionType);
                    }
                    throw new IllegalArgumentException("Unknown enum type: " + key.name());
                }
            }
            throw new IllegalStateException(key + " has unknown value type: " + (Object)((Object)key.getValueType()));
        }

        public List<OptionString.Entry> getUnknown() {
            return new ArrayList<OptionString.Entry>(this.unknown);
        }
    }
}

