/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;
import org.rocksdb.FlushReason;
import org.rocksdb.TableProperties;

public class FlushJobInfo {
    private final long columnFamilyId;
    private final String columnFamilyName;
    private final String filePath;
    private final long threadId;
    private final int jobId;
    private final boolean triggeredWritesSlowdown;
    private final boolean triggeredWritesStop;
    private final long smallestSeqno;
    private final long largestSeqno;
    private final TableProperties tableProperties;
    private final FlushReason flushReason;

    FlushJobInfo(long columnFamilyId, String columnFamilyName, String filePath, long threadId, int jobId, boolean triggeredWritesSlowdown, boolean triggeredWritesStop, long smallestSeqno, long largestSeqno, TableProperties tableProperties, byte flushReasonValue) {
        this.columnFamilyId = columnFamilyId;
        this.columnFamilyName = columnFamilyName;
        this.filePath = filePath;
        this.threadId = threadId;
        this.jobId = jobId;
        this.triggeredWritesSlowdown = triggeredWritesSlowdown;
        this.triggeredWritesStop = triggeredWritesStop;
        this.smallestSeqno = smallestSeqno;
        this.largestSeqno = largestSeqno;
        this.tableProperties = tableProperties;
        this.flushReason = FlushReason.fromValue(flushReasonValue);
    }

    public long getColumnFamilyId() {
        return this.columnFamilyId;
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public int getJobId() {
        return this.jobId;
    }

    public boolean isTriggeredWritesSlowdown() {
        return this.triggeredWritesSlowdown;
    }

    public boolean isTriggeredWritesStop() {
        return this.triggeredWritesStop;
    }

    public long getSmallestSeqno() {
        return this.smallestSeqno;
    }

    public long getLargestSeqno() {
        return this.largestSeqno;
    }

    public TableProperties getTableProperties() {
        return this.tableProperties;
    }

    public FlushReason getFlushReason() {
        return this.flushReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlushJobInfo that = (FlushJobInfo)o;
        return this.columnFamilyId == that.columnFamilyId && this.threadId == that.threadId && this.jobId == that.jobId && this.triggeredWritesSlowdown == that.triggeredWritesSlowdown && this.triggeredWritesStop == that.triggeredWritesStop && this.smallestSeqno == that.smallestSeqno && this.largestSeqno == that.largestSeqno && Objects.equals(this.columnFamilyName, that.columnFamilyName) && Objects.equals(this.filePath, that.filePath) && Objects.equals(this.tableProperties, that.tableProperties) && this.flushReason == that.flushReason;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnFamilyId, this.columnFamilyName, this.filePath, this.threadId, this.jobId, this.triggeredWritesSlowdown, this.triggeredWritesStop, this.smallestSeqno, this.largestSeqno, this.tableProperties, this.flushReason});
    }

    public String toString() {
        return "FlushJobInfo{columnFamilyId=" + this.columnFamilyId + ", columnFamilyName='" + this.columnFamilyName + '\'' + ", filePath='" + this.filePath + '\'' + ", threadId=" + this.threadId + ", jobId=" + this.jobId + ", triggeredWritesSlowdown=" + this.triggeredWritesSlowdown + ", triggeredWritesStop=" + this.triggeredWritesStop + ", smallestSeqno=" + this.smallestSeqno + ", largestSeqno=" + this.largestSeqno + ", tableProperties=" + this.tableProperties + ", flushReason=" + (Object)((Object)this.flushReason) + '}';
    }
}

