/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionDBOptions;
import org.rocksdb.TransactionOptions;
import org.rocksdb.TransactionalDB;
import org.rocksdb.WriteOptions;

public class TransactionDB
extends RocksDB
implements TransactionalDB<TransactionOptions> {
    private TransactionDBOptions transactionDbOptions_;

    private TransactionDB(long nativeHandle) {
        super(nativeHandle);
    }

    public static TransactionDB open(Options options, TransactionDBOptions transactionDbOptions, String path) throws RocksDBException {
        TransactionDB tdb = new TransactionDB(TransactionDB.open(options.nativeHandle_, transactionDbOptions.nativeHandle_, path));
        tdb.storeOptionsInstance(options);
        tdb.storeTransactionDbOptions(transactionDbOptions);
        return tdb;
    }

    public static TransactionDB open(DBOptions dbOptions, TransactionDBOptions transactionDbOptions, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        byte[][] cfNames = new byte[columnFamilyDescriptors.size()][];
        long[] cfOptionHandles = new long[columnFamilyDescriptors.size()];
        for (int i = 0; i < columnFamilyDescriptors.size(); ++i) {
            ColumnFamilyDescriptor cfDescriptor = columnFamilyDescriptors.get(i);
            cfNames[i] = cfDescriptor.getName();
            cfOptionHandles[i] = cfDescriptor.getOptions().nativeHandle_;
        }
        long[] handles = TransactionDB.open(dbOptions.nativeHandle_, transactionDbOptions.nativeHandle_, path, cfNames, cfOptionHandles);
        TransactionDB tdb = new TransactionDB(handles[0]);
        tdb.storeOptionsInstance(dbOptions);
        tdb.storeTransactionDbOptions(transactionDbOptions);
        for (int i = 1; i < handles.length; ++i) {
            columnFamilyHandles.add(new ColumnFamilyHandle(tdb, handles[i]));
        }
        return tdb;
    }

    @Override
    public void closeE() throws RocksDBException {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TransactionDB.closeDatabase(this.nativeHandle_);
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TransactionDB.closeDatabase(this.nativeHandle_);
            }
            catch (RocksDBException rocksDBException) {
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, TransactionOptions transactionOptions) {
        return new Transaction(this, this.beginTransaction(this.nativeHandle_, writeOptions.nativeHandle_, transactionOptions.nativeHandle_));
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, Transaction oldTransaction) {
        long jtxnHandle = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, oldTransaction.nativeHandle_);
        assert (jtxnHandle == oldTransaction.nativeHandle_);
        return oldTransaction;
    }

    @Override
    public Transaction beginTransaction(WriteOptions writeOptions, TransactionOptions transactionOptions, Transaction oldTransaction) {
        long jtxn_handle = this.beginTransaction_withOld(this.nativeHandle_, writeOptions.nativeHandle_, transactionOptions.nativeHandle_, oldTransaction.nativeHandle_);
        assert (jtxn_handle == oldTransaction.nativeHandle_);
        return oldTransaction;
    }

    public Transaction getTransactionByName(String transactionName) {
        long jtxnHandle = this.getTransactionByName(this.nativeHandle_, transactionName);
        if (jtxnHandle == 0L) {
            return null;
        }
        Transaction txn = new Transaction(this, jtxnHandle);
        txn.disOwnNativeHandle();
        return txn;
    }

    public List<Transaction> getAllPreparedTransactions() {
        long[] jtxnHandles = this.getAllPreparedTransactions(this.nativeHandle_);
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        for (long jtxnHandle : jtxnHandles) {
            Transaction txn = new Transaction(this, jtxnHandle);
            txn.disOwnNativeHandle();
            txns.add(txn);
        }
        return txns;
    }

    public Map<Long, KeyLockInfo> getLockStatusData() {
        return this.getLockStatusData(this.nativeHandle_);
    }

    private DeadlockInfo newDeadlockInfo(long transactionID, long columnFamilyId, String waitingKey, boolean exclusive) {
        return new DeadlockInfo(transactionID, columnFamilyId, waitingKey, exclusive);
    }

    public DeadlockPath[] getDeadlockInfoBuffer() {
        return this.getDeadlockInfoBuffer(this.nativeHandle_);
    }

    public void setDeadlockInfoBufferSize(int targetSize) {
        this.setDeadlockInfoBufferSize(this.nativeHandle_, targetSize);
    }

    private void storeTransactionDbOptions(TransactionDBOptions transactionDbOptions) {
        this.transactionDbOptions_ = transactionDbOptions;
    }

    @Override
    protected final native void disposeInternal(long var1);

    private static native long open(long var0, long var2, String var4) throws RocksDBException;

    private static native long[] open(long var0, long var2, String var4, byte[][] var5, long[] var6);

    private static native void closeDatabase(long var0) throws RocksDBException;

    private native long beginTransaction(long var1, long var3);

    private native long beginTransaction(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5);

    private native long beginTransaction_withOld(long var1, long var3, long var5, long var7);

    private native long getTransactionByName(long var1, String var3);

    private native long[] getAllPreparedTransactions(long var1);

    private native Map<Long, KeyLockInfo> getLockStatusData(long var1);

    private native DeadlockPath[] getDeadlockInfoBuffer(long var1);

    private native void setDeadlockInfoBufferSize(long var1, int var3);

    public static class DeadlockPath {
        final DeadlockInfo[] path;
        final boolean limitExceeded;

        public DeadlockPath(DeadlockInfo[] path, boolean limitExceeded) {
            this.path = path;
            this.limitExceeded = limitExceeded;
        }

        public boolean isEmpty() {
            return this.path.length == 0 && !this.limitExceeded;
        }
    }

    public static class DeadlockInfo {
        private final long transactionID;
        private final long columnFamilyId;
        private final String waitingKey;
        private final boolean exclusive;

        private DeadlockInfo(long transactionID, long columnFamilyId, String waitingKey, boolean exclusive) {
            this.transactionID = transactionID;
            this.columnFamilyId = columnFamilyId;
            this.waitingKey = waitingKey;
            this.exclusive = exclusive;
        }

        public long getTransactionID() {
            return this.transactionID;
        }

        public long getColumnFamilyId() {
            return this.columnFamilyId;
        }

        public String getWaitingKey() {
            return this.waitingKey;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }
    }

    public static class KeyLockInfo {
        private final String key;
        private final long[] transactionIDs;
        private final boolean exclusive;

        public KeyLockInfo(String key, long[] transactionIDs, boolean exclusive) {
            this.key = key;
            this.transactionIDs = transactionIDs;
            this.exclusive = exclusive;
        }

        public String getKey() {
            return this.key;
        }

        public long[] getTransactionIDs() {
            return this.transactionIDs;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }
    }
}

