# Description
Checks for vertically aligned parameters

# Extended Information
Checks:
* function module calls
* method calls
* `VALUE` constructors
* `NEW` constructors
* `RAISE EXCEPTION` statements
* `CREATE OBJECT` statements
* `RAISE EVENT` statements

https://github.com/SAP/styleguides/blob/master/clean-abap/CleanABAP.md#align-parameters

Does not take effect on non functional method calls, use https://rules.abaplint.org/functional_writing/

If parameters are on the same row, no issues are reported, see
https://rules.abaplint.org/max_one_method_parameter_per_line/ for splitting parameters to lines

# Examples
**Bad example**
```abap
CALL FUNCTION 'FOOBAR'
  EXPORTING
    foo = 2
    parameter = 3.

foobar( moo = 1
  param = 1 ).

foo = VALUE #(
    foo = bar
        moo = 2 ).
```

**Good example**
```abap
CALL FUNCTION 'FOOBAR'
  EXPORTING
    foo       = 2
    parameter = 3.

foobar( moo   = 1
        param = 1 ).

foo = VALUE #(
    foo = bar
    moo = 2 ).

DATA(sdf) = VALUE type(
  common_val     = 2
  another_common = 5
  ( row_value = 4
    value_foo = 5 ) ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/align_parameters) <br>
