# Description
Checks that the code does not contain empty blocks.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#no-empty-if-branches

# Clean ABAP Code Style Guide
```ABAP
IF has_entries = abap_false.
  " do some magic
ENDIF.
```

is shorter and clearer than

```ABAP
" anti-pattern
IF has_entries = abap_true.
ELSE.
  " do some magic
ENDIF.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/empty_structure) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
