# Description
Finds pragmas which can be removed

# Extended Information
* `NO_HANDLER` with handler

* `NEEDED` without definition

* `NO_TEXT` without texts

* `SUBRC_OK` where `sy-subrc` is checked

`NO_HANDLER` inside macros are not checked

# Examples
**Bad example**
```abap
TRY.
    ...
  CATCH zcx_abapgit_exception ##NO_HANDLER.
    RETURN. " it has a handler
ENDTRY.
MESSAGE w125(zbar) WITH c_foo INTO message ##NEEDED ##NO_TEXT.
SELECT SINGLE * FROM tadir INTO @DATA(sdfs) ##SUBRC_OK.
IF sy-subrc <> 0.
ENDIF.
```

**Good example**
```abap
TRY.
    ...
  CATCH zcx_abapgit_exception.
    RETURN.
ENDTRY.
MESSAGE w125(zbar) WITH c_foo INTO message.
SELECT SINGLE * FROM tadir INTO @DATA(sdfs).
IF sy-subrc <> 0.
ENDIF.

DATA: BEGIN OF blah ##NEEDED,
        test1 TYPE string,
        test2 TYPE string,
      END OF blah.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/unnecessary_pragma) <br>
