

Binding to all network interfaces can potentially open up a service to traffic
on unintended interfaces, that may not be properly documented or secured. This
plugin test looks for a string pattern "0.0.0.0" that may indicate a hardcoded
binding to all network interfaces.

## Example

``` python

>> Issue: Possible binding to all interfaces.
Severity: Medium   Confidence: Medium
CWE: CWE-605 (https://cwe.mitre.org/data/definitions/605.html)
Location: ./examples/binding.py:4
3   s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
4   s.bind(('0.0.0.0', 31137))
5   s.bind(('192.168.0.1', 8080))

```
## see also:

- https://nvd.nist.gov/vuln/detail/CVE-2018-1281
- https://cwe.mitre.org/data/definitions/605.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added

