

Jinja2 is a Python HTML templating system. It is typically used to build web
applications, though appears in other places well, notably the Ansible
automation system. When configuring the Jinja2 environment, the option to use
autoescaping on input can be specified. When autoescaping is enabled, Jinja2
will filter input strings to escape any HTML content submitted via template
variables. Without escaping HTML input the application becomes vulnerable to
Cross Site Scripting (XSS) attacks.

Unfortunately, autoescaping is False by default. Thus this plugin test will
warn on omission of an autoescape setting, as well as an explicit setting of
false. A HIGH severity warning is generated in either of these scenarios.

## Example

``` python

>> Issue: Using jinja2 templates with autoescape=False is dangerous and can
lead to XSS. Use autoescape=True to mitigate XSS vulnerabilities.
Severity: High   Confidence: High
CWE: CWE-94 (https://cwe.mitre.org/data/definitions/94.html)
Location: ./examples/jinja2_templating.py:11
10  templateEnv = jinja2.Environment(autoescape=False,
loader=templateLoader)
11  Environment(loader=templateLoader,
12              load=templateLoader,
13              autoescape=False)
14

>> Issue: By default, jinja2 sets autoescape to False. Consider using
autoescape=True or use the select_autoescape function to mitigate XSS
vulnerabilities.
Severity: High   Confidence: High
CWE: CWE-94 (https://cwe.mitre.org/data/definitions/94.html)
Location: ./examples/jinja2_templating.py:15
14
15  Environment(loader=templateLoader,
16              load=templateLoader)
17
18  Environment(autoescape=select_autoescape(['html', 'htm', 'xml']),
19              loader=templateLoader)


```
## see also:

- `OWASP XSS <https://www.owasp.org/index.php/Cross-site_Scripting_(XSS)>`_
- https://realpython.com/primer-on-jinja-templating/
- https://jinja.palletsprojects.com/en/2.11.x/api/#autoescaping
- https://security.openstack.org/guidelines/dg_cross-site-scripting-xss.html
- https://cwe.mitre.org/data/definitions/94.html

New in version  0.10.0

Changed in version  1.7.3
CWE information added

