
From [Effective Dart](https://dart.dev/effective-dart/usage#do-use--instead-of--for-empty-constructor-bodies):

**DO** use `;` instead of `{}` for empty constructor bodies.

In Dart, a constructor with an empty body can be terminated with just a
semicolon.  This is required for const constructors.  For consistency and
brevity, other constructors should also do this.

**BAD:**
```dart
class Point {
  int x, y;
  Point(this.x, this.y) {}
}
```

**GOOD:**
```dart
class Point {
  int x, y;
  Point(this.x, this.y);
}
```
