
**DO** use super parameter names that match their corresponding super
constructor's parameter names.

**BAD:**

```dart
class Rectangle {
  final int width;
  final int height;
  
  Rectangle(this.width, this.height);
}

class ColoredRectangle extends Rectangle {
  final Color color;
  
  ColoredRectangle(
    this.color,
    super.height, // Bad, actually corresponds to the `width` parameter.
    super.width, // Bad, actually corresponds to the `height` parameter.
  ); 
}
```

**GOOD:**

```dart
class Rectangle {
  final int width;
  final int height;
  
  Rectangle(this.width, this.height);
}

class ColoredRectangle extends Rectangle {
  final Color color;
  
  ColoredRectangle(
    this.color,
    super.width,
    super.height, 
  ); 
}
```