
**PREFER** using the default unnamed Constructor over `.new`.

Given a class `C`, the named unnamed constructor `C.new` refers to the same
constructor as the unnamed `C`. As such it adds nothing but visual noise to
invocations and should be avoided (unless being used to identify a constructor
tear-off).

**BAD:**
```dart
class A {
  A.new(); // LINT
}

var a = A.new(); // LINT
```

**GOOD:**
```dart
class A {
  A.ok();
}

var a = A();
var aa = A.ok();
var makeA = A.new;
```