Component selectors should follow given naming rules. See more at https://angular.io/guide/styleguide#style-02-07, https://angular.io/guide/styleguide#style-05-02
and https://angular.io/guide/styleguide#style-05-03.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'foo-bar'
            ~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'app-foo-bar'
            ~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: '[app-foo-bar]'
            ~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'app-foo-bar[baz].app'
            ~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: '[ng-bar-foo]'
            ~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'appFooBar'
            ~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'app'
            ~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: '[appFooBar]'
            ~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: `app-foo-bar`
            ~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'appFooBar'
            ~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  encapsulation: ViewEncapsulation.ShadowDom,
  selector: 'appFooBar'
            ~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  encapsulation: ViewEncapsulation.ShadowDom,
  selector: 'app'
            ~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'root'
            ~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'sgggg-bar'
            ~~~~~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'sg-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: '[ng-foo-bar]'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-foo-bar[baz].app'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({ selector: 'app-bar' }) class TestOne {}
@Component({ selector: 'ngg-bar' }) class TestTwo {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'appBarFoo'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app1-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const selectorName = 'appFooBar';
@Component({
  selector: selectorName
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'baz-[app-bar-foo][foe].bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-bar-foo[baz].bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: \`[appFooBar]\`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: \`
    [appFooBar]
  \`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: \`
    [appFooBar],
    [appBarFoo]
  \`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: \`button[appFooBar]\`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: \`app-foo-bar\`,
  encapsulation: ViewEncapsulation.ShadowDom
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: \`app-foo-bar\`,
  encapsulation: ViewEncapsulation.ShadowDom
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'singleword'
})
class Test {}
```

</details>
