Directive selectors should follow given naming rules. See more at https://angular.io/guide/styleguide#style-02-06 and https://angular.io/guide/styleguide#style-02-08.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'app-foo-bar'
            ~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: '[app-foo-bar]'
            ~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'app-foo-bar[baz].app'
            ~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: '[app-bar-foo]'
            ~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'appFooBar'
            ~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'app'
            ~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: `app-foo-bar`
            ~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: '[appFooBar]'
            ~~~~~~~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: '[app-foo-bar]'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-foo-bar[baz].app'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({ selector: 'app-bar' }) class TestOne {}
@Directive({ selector: 'ngg-bar' }) class TestTwo {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'appBarFoo'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app1-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const selectorName = 'appFooBar';
@Directive({
  selector: selectorName
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: \`[app-foo-bar]\`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'baz-[app-bar-foo][foe].bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-bar-foo[baz].bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: \`
    [app-foo-bar]
  \`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: \`
    [app-foo-bar],
    [app-bar-foo]
  \`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'button[app-foo-bar]'
})
class Test {}
```

</details>
