Disallows usage of `forwardRef` references for DI

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'test',
  template: ''
})
export class Test {
  constructor(@Inject(forwardRef(() => TestService)) testService) {}
                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}
export class TestService {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  providers: [
    {
      multi: true,
      provide: NG_VALUE_ACCESSOR,
      useExisting: forwardRef(() => TagsValueAccessor)
                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    }
  ],
  selector: '[tags]',
})
export class TagsValueAccessor {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const TAGS_VALUE_ACCESSOR: StaticProvider = {
  multi: true,
  provide: NG_VALUE_ACCESSOR,
  useExisting: forwardRef(() => TagsValueAccessor)
               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
};
@Directive({
  providers: [TAGS_VALUE_ACCESSOR],
  selector: '[tags]'
})
export class TagsValueAccessor {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'test',
  template: ''
})
export class Test {
  constructor() {
    this.test();
  }

  test() {}
}
```

</details>
