Ensures that input bindings are not aliased

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  inputs: ['a: b']
           ~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  outputs: ['abort'],
  'inputs': [boundary, `test: copy`, 'check: check'],
                       ~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  ['inputs']: ['orientation: orientation'],
               ~~~~~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  [`inputs`]: ['orientation: orientation'],
               ~~~~~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Custom() @Input(`change`) _change = getInput();
                   ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Input('change') change = (this.subject$ as Subject<{blur: boolean}>).pipe();
         ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Input({ alias: 'change' }) change = (this.subject$ as Subject<{blur: boolean}>).pipe();
                  ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'foo'
})
class Test {
  @Input('aria-invalid') ariaBusy: string;
         ~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'foo'
})
class Test {
  @Input('fooColor') colors: string;
         ~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  'selector': 'foo'
})
class Test {
  @Input('foocolor') color: string;
         ~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  selector: 'click',
})
class Test {}

@Injectable()
class Test {
  @Input('click') blur = this.getInput();
         ~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'img[fooDirective]',
})
class Test {
  @Input('notFooDirective') foo: Foo;
         ~~~~~~~~~~~~~~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Page({
  inputs: ['play', popstate, `online`, 'obsolete: obsol', 'store: storage'],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  change = new EventEmitter();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Input() buttonChange = new EventEmitter<'change'>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  inputs,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  inputs: [...test],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  inputs: func(),
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  inputs: [func(), 'a'],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'qx-menuitem',
  hostDirectives: [{
    directive: CdkMenuItem,
    inputs: ['cdkMenuItemDisabled: disabled'],
  }]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'qx-menuitem',
  'hostDirectives': [{
    directive: CdkMenuItem,
    inputs: ['cdkMenuItemDisabled: disabled'],
  }]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'qx-menuitem',
  ['hostDirectives']: [{
    directive: CdkMenuItem,
    inputs: ['cdkMenuItemDisabled: disabled'],
  }]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({})
class Test {
  @Input() set setter(setter: string) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  inputs: ['foo: aria-wrong']
})
class Test {
  @Input('aria-wrong') set setter(setter: string) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const change = 'change';
@Component()
class Test {
  @Input(change) touchMove: EventEmitter<{ action: 'click' | 'close' }> = new EventEmitter<{ action: 'click' | 'close' }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const blur = 'blur';
const click = 'click';
@Directive()
class Test {
  @Input(blur) [click]: EventEmitter<Blur>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'foo[bar]'
})
class Test {
  @Input() bar: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: '[foo], test',
})
class Test {
  @Input('foo') label: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'foo'
})
class Test {
  @Input('aria-label') ariaLabel: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  inputs: ['foo: allowedName']
})
class Test {
  @Input() bar: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'foo'
})
class Test {
  @Input('fooMyColor') myColor: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'img[fooDirective]'
})
class Test {
  @Input foo: Foo;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'img[fooDirective]'
})
class Test {
  @Input('fooDirective') foo: Foo;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'foo'
})
class Test {
  @Input({ required: true }) name: string;
}
```

</details>
