Ensures that output bindings, including aliases, are not named as standard DOM events

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  'outputs': ['pagehide']
              ~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  inputs: ['abort'],
  ['outputs']: [boundary, `test: copy`],
                          ~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  inputs: ['abort'],
  [`outputs`]: [boundary, `test: copy`],
                          ~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  outputs: ['orientationchange: orientation'],
            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Output() change: EventEmitter<any> = new EventEmitter<{}>();
            ~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Output() @Custom('change') 'change' = new EventEmitter<void>();
                              ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Custom() @Output(`change`) _change = getOutput();
                    ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  @Output('change') _change = (this.subject$ as Subject<{blur: boolean}>).pipe();
          ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  @Output('getter') get 'cut'() {}
                        ~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  @Output('click') blur = this.getOutput();
          ~~~~~~~  ~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Page({
  outputs: ['play', popstate, `online`, 'obsolete: obsol', 'store: storage'],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  change = new EventEmitter();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Output() buttonChange = new EventEmitter<'change'>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  @Output() Drag = new EventEmitter<{ click: string }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  @Output(`changelower`) changeText = new EventEmitter<{ bar: string, blur: string }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  @Output('buttonChange') changelower = new EventEmitter<ComplextObject>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test<SVGScroll> {
  @Output() SVgZoom = new EventEmitter<SVGScroll>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const change = 'change';
@Component()
class Test {
  @Output(change) touchMove: EventEmitter<{ action: 'click' | 'close' }> = new EventEmitter<{ action: 'click' | 'close' }>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const blur = 'blur';
const click = 'click';
@Directive()
class Test {
  @Output(blur) [click]: EventEmitter<Blur>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'foo',
})
class Test {
  @Output() get 'getter'() {}
}
```

</details>
