Enforce consistent prefix for pipes.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'foo-bar'
        ~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'foo-bar'
        ~~~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Pipe
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
export function mockPipe(name: string): any {
  @Pipe({ name })
  class MockPipe implements PipeTransform {
    transform(input: any): any {
      return input;
    }
  }
  return MockPipe;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'ngBarFoo'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'ngBarFoo'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'ngBarFoo'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: \`ngBarFoo\`
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const pipeName = 'fooBar';
@Pipe({
  name: pipeName
})
class Test {}
```

</details>
