Ensures that the `tabindex` attribute is not positive

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div tabindex="5"></div>
               ~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [attr.tabindex]="21"></div>
                      ~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<span></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span id="2"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span tabindex></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span tabindex="-1"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span tabindex="0"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span [attr.tabindex]="-1"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span [attr.tabindex]="0"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span [attr.tabindex]="tabIndex"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span [attr.tabindex]="null"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span [attr.tabindex]="undefined"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-test [tabindex]="1"></app-test>
```

</details>
