[Accessibility] Ensures that the `scope` attribute is only used on the `<th>` element

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
{{ test }}<div scope></div>
               ~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [attr.scope]="scope"></div><p></p>
     ~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<th></th>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<th scope="col"></th>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<th [scope]="'col'"></th>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<th [attr.scope]="scope"></th>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div Scope="col"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button [appscope]="col"></button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-table scope></app-table>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-row [scope]="row"></app-row>
```

</details>
