Ensures trackBy function is used

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<ul>
  <li *ngFor="let item of [1, 2, 3];">
      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {{ item }}
  </li>
</ul>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ul>
  <li *ngFor="let item of [1, 2, 3];">
      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {{ item }}
  </li>
</ul>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template ngFor let-item [ngForOf]="[1, 2, 3]" let-i="index">
                            ~~~~~~~~~~~~~~~~~~~~~
  {{ item }}
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template ngFor let-item [ngForOf]="[1, 2, 3]" let-i="index">
                            ~~~~~~~~~~~~~~~~~~~~~
  {{ item }}
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngFor="let item of [1, 2, 3]; trackBy: trackByFn">
  {{ item }}
</div>
<ul>
  <li *ngFor="let item of [1, 2, 3];">
      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {{ item }}
  </li>
</ul>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngFor="let item of [1, 2, 3];">
     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  {{ item }}
</div>
<ng-template ngFor let-item [ngForOf]="[1, 2, 3]" let-i="index">
                            ~~~~~~~~~~~~~~~~~~~~~
  {{ item }}
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngFor="let item of [1, 2, 3]; trackBy: trackByFn">
  {{ item }}
</div>
<div *ngFor="let item of [1, 2, 3]; trackByProperty: trackByFn">
  {{ item }}
</div>
<ul>
  <li *ngFor="let item of [1, 2, 3];">
      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {{ item }}
  </li>
</ul>
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<div *ngFor="let item of [1, 2, 3]; trackBy: trackByFn">
  {{ item }}
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor="let item of [1, 2, 3]; let i = index; trackBy: trackByFn">
  {{ item }}
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor="let item of [1, 2, 3]; trackBy : trackByFn">
  {{ item }}
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor='let item of [1, 2, 3]; let i = index; trackBy: trackByFn'>
  {{ item }}
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor  =  "let item of [1, 2, 3]; let i = index; trackBy : trackByFn">
  {{ item }}
</div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template ngFor let-item [ngForOf]="[1, 2, 3]" let-i="index"
  [ngForTrackBy]="trackByFn">
  {{ item }}
</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor="let item of ['a', 'b', 'c']; index as i; trackBy: trackByFn">
  {{ item }}
</div>

<ng-template ngFor let-item [ngForOf]="[1, 2, 3]" let-i="index"
  [ngForTrackBy]="trackByFn">
  {{ item }}
</ng-template>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor="
  let item of [1, 2, 3];
  let i = index;
  trackBy : trackByFn
">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor="
  let item of [1, 2, 3];
  let i = index;
  trackByProperty: 'id'
">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngFor="let photo of photos; trackById"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<ng-template ngFor let-item [ngForOf]="[1, 2, 3]" let-i="index" [ngForTrackByProperty]="trackByFn">
  {{ item }}
</ng-template>
```

</details>
