Require Promise-like statements to be handled appropriately.


A "floating" Promise is one that is created without any code set up to handle any errors it might throw.
Floating Promises can cause several issues, such as improperly sequenced operations, ignored Promise rejections, and more.

This rule reports when a Promise is created and not properly handled.
Valid ways of handling a Promise-valued statement include:

- `await`ing it
- `return`ing it
- Calling its `.then()` with two arguments
- Calling its `.catch()` with one argument

`no-floating-promises` only detects unhandled Promise _statements_.
See [`no-misused-promises`](https://typescript-eslint.io/rules/no-misused-promises) for detecting code that provides Promises to _logical_ locations such as if statements.
## Examples

<!--tabs-->

### ❌ Incorrect

```ts
const promise = new Promise((resolve, reject) => resolve('value'));
promise;

async function returnsPromise() {
  return 'value';
}
returnsPromise().then(() => {});

Promise.reject('value').catch();

Promise.reject('value').finally();
```

### ✅ Correct

```ts
const promise = new Promise((resolve, reject) => resolve('value'));
await promise;

async function returnsPromise() {
  return 'value';
}
returnsPromise().then(
  () => {},
  () => {},
);

Promise.reject('value').catch(() => {});

Promise.reject('value').finally(() => {});
```

## When Not To Use It

If you do not use Promise-like values in your codebase, or want to allow them to remain unhandled.

## Related To

- [`no-misused-promises`](https://typescript-eslint.io/rules/no-misused-promises)
