Require both operands of addition to be the same type and be `bigint`, `number`, or `string`.


TypeScript allows `+` adding together two values of any type(s).
However, adding values that are not the same type and/or are not the same primitive type is often a sign of programmer error.

This rule reports when a `+` operation combines two values of different types, or a type that is not `bigint`, `number`, or `string`.

## Examples

<!--tabs-->

### ❌ Incorrect

```ts
var foo = '5.5' + 5;
var foo = 1n + 1;
```

### ✅ Correct

```ts
var foo = parseInt('5.5', 10) + 10;
var foo = 1n + 1n;
```

## When Not To Use It

If you don't mind `"[object Object]"` in your strings, then you will not need this rule.

## Related To

- [`no-base-to-string`](https://typescript-eslint.io/rules/no-base-to-string)
- [`restrict-template-expressions`](https://typescript-eslint.io/rules/restrict-template-expressions)

## Further Reading

- [`Object.prototype.toString()` MDN documentation](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toString)
