Enforce React components to have a shouldComponentUpdate method.


This rule prevents you from creating React components without declaring a `shouldComponentUpdate` method.

## Rule Details

Examples of **incorrect** code for this rule:

```js
class YourComponent extends React.Component {

}
```

```js
createReactClass({
});
```

Examples of **correct** code for this rule:

```js
class YourComponent extends React.Component {
  shouldComponentUpdate () {
    return false;
  }
}
```

```js
createReactClass({
  shouldComponentUpdate: function () {
    return false;
  }
});
```

```js
createReactClass({
  mixins: [PureRenderMixin]
});
```

```js
@reactMixin.decorate(PureRenderMixin)
createReactClass({

});
```
