> "There are only two hard things in Computer Science: cache invalidation and naming things." — Phil Karlton

Generic names can lead to hard-to-decipher code. This rule allows you to specify a deny list of disallowed identifier names to avoid this practice.

## Rule Details

This rule disallows specified identifiers in assignments and `function` definitions.

This rule will catch disallowed identifiers that are:

* variable declarations
* function declarations
* object properties assigned to during object creation
* class fields
* class methods

It will not catch disallowed identifiers that are:

* function calls (so you can still use functions you do not have control over)
* object properties (so you can still use objects you do not have control over)

## When Not To Use It

You can turn this rule off if you do not want to restrict the use of certain identifiers.
