Line too long. This is a pragmatic equivalent of
`pycodestyle`'s `E501`: it considers "max-line-length" but only triggers
when the value has been exceeded by **more than 10%**. `noqa` and `type: ignore` comments are ignored. You will no
longer be forced to reformat code due to the closing parenthesis being
one character too far to satisfy the linter. At the same time, if you do
significantly violate the line length, you will receive a message that
states what the actual limit is. This is inspired by Raymond Hettinger's
`"Beyond PEP 8" talk <https://www.youtube.com/watch?v=wf-BqAjZb8M>`_ and
highway patrol not stopping you if you drive < 5mph too fast. Disable
`E501` to avoid duplicate warnings. Like `E501`, this error ignores long shebangs
on the first line and urls or paths that are on their own line::

  #! long shebang ignored

  # https://some-super-long-domain-name.com/with/some/very/long/paths
  url = (
      "https://some-super-long-domain-name.com/with/some/very/long/paths"
  )