Lambdas should not be assigned to a variable. Instead, they should be defined as functions.

The primary reason for this is debugging. Lambdas show as `<lambda>` in tracebacks, where functions will display the function's name.

### Anti-pattern

```python
root = lambda folder_name: os.path.join(BASE_DIR, folder_name)
```

### Best practice

```python
def root(folder_name):
    return os.path.join(BASE_DIR, folder_name)
```
