Line breaks should occur before the binary operator to keep all operators aligned.

This rule was changed on April 16th, 2016 in [this commit](https://github.com/python/peps/commit/c59c4376ad233a62ca4b3a6060c81368bd21e85b).  The tool [is updated](https://github.com/PyCQA/pycodestyle/pull/502) to recommend that line breaks *should* occur before the binary operator because it keeps all operators aligned. However older versions of tooling can still recommend the previous behaviour. See also W503.

### Anti-pattern

```python
income = (gross_wages +
          taxable_interest)
```

### Best practice

```python
income = (gross_wages
          + taxable_interest)
```
