The pod specification does not contain an entry for terminationGracePeriodSeconds. Specify the necessary duration for a graceful shut down in order to prevent force shut downs which could lead to data loss.

# Details
For a voluntary disruption Kubernetes sends a `SIGTERM` signal to the pod as first step in the termination process.
Sending the `SIGTERM` signal starts the termination grace period, which defaults to 30 seconds.
During this period of time the pod has to do tasks like saving data and its state, closing network connections, finishing their current request or task.
If the pod finished its graceful termination, Kubernetes immediately continues with the termination process without waiting for the full 30 seconds to pass.
But if the time is up and the pod did not finish its graceful termination, Kubernetes sends a `SIGKILL` signal forcing the pod to shut down.
A forced shut down could lead to memory leaks or data loss which would be fatal.
Thus, knowing the maximum time needed for pods to gracefully terminate and setting the termination grace period correctly is a critical best practice.
Despite the fact that Kubernetes immediately continues when the pod finished its termination, it is not suitable to set the termination grace period infinitely high.
A pod could run in a deadlock during termination making the force shut down necessary.
An infinitely high termination grace period would cause the system to get stale and cancel the failure recovery mechanisms.
Thus, setting the termination grace period correctly is important for a graceful shut down and performance reasons.

# Further Reading:
- Rémy-Christophe Schermesser. 8 Algolia-Tested Best Practices for Kubernetes. June 13, 2019. url: https://blog.algolia.com/8-algolia-tested-best-practices-kubernetes/
- Sandeep Dinesh. Kubernetes best practices: terminating with grace. May 18, 2018. url: https://cloud.google.com/blog/products/gcp/kubernetes-best-practices-terminating-with-grace