### SCS0006 - Weak hashing function 

MD5 or SHA1 have known collision weaknesses and are no longer considered strong hashing algorithms.

#### Vulnerable Code

```cs
var hashProvider = new SHA1CryptoServiceProvider();
var hash = hashProvider.ComputeHash(str);

```

#### Solution

Use SHA256 or SHA512\. Notice, that hashing algorithms are designed to be fast and shouldn’t be used directly for hashing passwords. Use [adaptive algorithms](https://crackstation.net/hashing-security.htm) for the purpose.

```cs
var hashProvider = SHA256Managed.Create();
var hash = hashProvider.ComputeHash(str);

```

#### References

[CWE-327: Use of a Broken or Risky Cryptographic Algorithm](https://cwe.mitre.org/data/definitions/327.html)  
[MSDN: SHA256 Class documentation](https://msdn.microsoft.com/en-us/library/system.security.cryptography.sha256%28v=vs.110%29.aspx)  
[Salted Password Hashing - Doing it Right](https://crackstation.net/hashing-security.htm)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)