### SCS0008 - Cookie Without SSL Flag 

It is recommended to specify the Secure flag to new cookie.

#### Risk

The Secure flag is a directive to the browser to make sure that the cookie is not sent by unencrypted channel

#### Vulnerable Code

The `requireSSL` value is explicitly set to `false` or the default is left.

```xml
<httpCookies requireSSL="false" [..] />

```

```cs
// default is left
var cookie = new HttpCookie("test");
// or explicitly set to false
var cookie = new HttpCookie("test");
cookie.Secure = false;

```

#### Solution

```xml
<httpCookies requireSSL="true" [..] />

```

```cs
var cookie = new HttpCookie("test");
cookie.Secure = true; //Add this flag
cookie.HttpOnly = true;

```

#### References

[CWE-614: Sensitive Cookie in HTTPS Session Without ‘Secure’ Attribute](https://cwe.mitre.org/data/definitions/614.html)  
[OWASP: Secure Flag](https://www.owasp.org/index.php/SecureFlag)  
[Rapid7: Missing Secure Flag From SSL Cookie](https://www.rapid7.com/db/vulnerabilities/http-cookie-secure-flag)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)