<h2>Why is this an issue?</h2>
<p><a href="https://learn.microsoft.com/en-us/dotnet/api/system.gc.collect">GC.Collect</a> is a method that forces or suggests to the <a
href="https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/">garbage collector</a> to run a collection of objects in the managed heap
that are no longer being used and free their memory.</p>
<p>Calling <code>GC.Collect</code> is rarely necessary and can significantly affect application performance. That’s because it is a <a
href="https://en.wikipedia.org/wiki/Tracing_garbage_collection">tracing garbage collector</a> and needs to examine <em>every object in memory</em> for
cleanup and analyze all reachable objects from every application’s root (static fields, local variables on thread stacks, etc.).</p>
<p>To perform tracing and memory releasing correctly, the garbage collection <a
href="https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/latency">may</a> need to block all threads currently in execution. That is
why, as a general rule, the <a
href="https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/performance#troubleshoot-performance-issues">performance implications</a>
of calling <code>GC.Collect</code> far outweigh the benefits.</p>
<p>This rule raises an issue when any overload of <code>Collect</code> is invoked.</p>
<pre>
static void Main(string[] args)
{
  // ...
  GC.Collect();                              // Noncompliant
  GC.Collect(2, GCCollectionMode.Optimized); // Noncompliant
}
</pre>
<p>There may be exceptions to this rule: for example, you’ve just triggered some event that is unique in the run of your program that caused a lot of
long-lived objects to die, and you want to release their memory.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/">Garbage collection</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.gc.collect">GC.Collect</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/latency">Garbage collection latency modes</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/performance#troubleshoot-performance-issues">Garbage collection
  troubleshoot performance issues</a> </li>
</ul>

