<h2>Why is this an issue?</h2>
<p>A <code>for</code> loop stop condition should test the loop counter against an invariant value (i.e. one that is true at both the beginning and
ending of every loop iteration). Ideally, this means that the stop condition is set to a local variable just before the loop begins.</p>
<p>Stop conditions that are not invariant are slightly less efficient, as well as being difficult to understand and maintain, and likely lead to the
introduction of errors in the future.</p>
<p>This rule tracks three types of non-invariant stop conditions:</p>
<ul>
  <li> When the loop counters are updated in the body of the <code>for</code> loop </li>
  <li> When the stop condition depend upon a method call </li>
  <li> When the stop condition depends on an object property, since such properties could change during the execution of the loop. </li>
</ul>
<h2>How to fix it</h2>
<p>It’s generally recommended to only update the loop counter in the loop declaration. If skipping elements or iterating at a different pace based on
a condition is needed, consider using a while loop or a different structure that better fits the needs.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
for (int i = 1; i &lt;= 5; i++)
{
    Console.WriteLine(i);
    if (condition)
    {
        i = 20;
    }
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
int i = 1;
while (i &lt;= 5)
{
    Console.WriteLine(i);
    if (condition)
    {
        i = 20;
    }
    else
    {
        i++;
    }
}
</pre>

