<h2>Why is this an issue?</h2>
<p>The requirement for a final <code>default</code> clause is defensive programming. The clause should either take appropriate action, or contain a
suitable comment as to why no action is taken. Even when the <code>switch</code> covers all current values of an <code>enum</code>, a
<code>default</code> case should still be used because there is no guarantee that the <code>enum</code> won’t be extended.</p>
<h3>Noncompliant code example</h3>
<pre>
int foo = 42;
switch (foo) // Noncompliant
{
  case 0:
    Console.WriteLine("foo = 0");
    break;
  case 42:
    Console.WriteLine("foo = 42");
    break;
}
</pre>
<h3>Compliant solution</h3>
<pre>
int foo = 42;
switch (foo) // Compliant
{
  case 0:
    Console.WriteLine("foo = 0");
    break;
  case 42:
    Console.WriteLine("foo = 42");
    break;
  default:
    throw new InvalidOperationException("Unexpected value foo = " + foo);
}
</pre>
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/478">CWE-478 - Missing Default Case in Switch Statement</a> </li>
</ul>

