<p>Hardcoding IP addresses is security-sensitive. It has led in the past to the following vulnerabilities:</p>
<ul>
  <li> <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5901">CVE-2006-5901</a> </li>
  <li> <a href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2005-3725">CVE-2005-3725</a> </li>
</ul>
<p>Today’s services have an ever-changing architecture due to their scaling and redundancy needs. It is a mistake to think that a service will always
have the same IP address. When it does change, the hardcoded IP will have to be modified too. This will have an impact on the product development,
delivery, and deployment:</p>
<ul>
  <li> The developers will have to do a rapid fix every time this happens, instead of having an operation team change a configuration file. </li>
  <li> It misleads to use the same address in every environment (dev, sys, qa, prod). </li>
</ul>
<p>Last but not least it has an effect on application security. Attackers might be able to decompile the code and thereby discover a potentially
sensitive address. They can perform a Denial of Service attack on the service, try to get access to the system, or try to spoof the IP address to
bypass security checks. Such attacks can always be possible, but in the case of a hardcoded IP address solving the issue will take more time, which
will increase an attack’s impact.</p>
<h2>Ask Yourself Whether</h2>
<p>The disclosed IP address is sensitive, e.g.:</p>
<ul>
  <li> Can give information to an attacker about the network topology. </li>
  <li> It’s a personal (assigned to an identifiable person) IP address. </li>
</ul>
<p>There is a risk if you answered yes to any of these questions.</p>
<h2>Recommended Secure Coding Practices</h2>
<p>Don’t hard-code the IP address in the source code, instead make it configurable with environment variables, configuration files, or a similar
approach. Alternatively, if confidentially is not required a domain name can be used since it allows to change the destination quickly without having
to rebuild the software.</p>
<h2>Sensitive Code Example</h2>
<pre>
var ip = "192.168.12.42";
var address = IPAddress.Parse(ip);
</pre>
<h2>Compliant Solution</h2>
<pre>
var ip = ConfigurationManager.AppSettings["myapplication.ip"];
var address = IPAddress.Parse(ip);
</pre>
<h2>Exceptions</h2>
<p>No issue is reported for the following cases because they are not considered sensitive:</p>
<ul>
  <li> Loopback addresses 127.0.0.0/8 in CIDR notation (from 127.0.0.0 to 127.255.255.255) </li>
  <li> Broadcast address 255.255.255.255 </li>
  <li> Non-routable address 0.0.0.0 </li>
  <li> Strings of the form <code>2.5.&lt;number&gt;.&lt;number&gt;</code> as they <a href="http://www.oid-info.com/introduction.htm">often match
  Object Identifiers</a> (OID) </li>
  <li> Addresses in the ranges 192.0.2.0/24, 198.51.100.0/24, 203.0.113.0/24, reserved for documentation purposes by <a
  href="https://datatracker.ietf.org/doc/html/rfc5737">RFC 5737</a> </li>
  <li> Addresses in the range 2001:db8::/32, reserved for documentation purposes by <a href="https://datatracker.ietf.org/doc/html/rfc3849">RFC
  3849</a> </li>
</ul>
<h2>See</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A01_2021-Broken_Access_Control/">Top 10 2021 Category A1 - Broken Access Control</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure">Top 10 2017 Category A3 - Sensitive Data
  Exposure</a> </li>
</ul>

