<h2>Why is this an issue?</h2>
<p>When a test fails due, for example, to infrastructure issues, you might want to ignore it temporarily. But without some kind of notation about why
the test is being ignored, it may never be reactivated. Such tests are difficult to address without comprehensive knowledge of the project, and end up
polluting their projects.</p>
<p>This rule raises an issue for each ignored test that does not have a <code>WorkItem</code> attribute nor a comment about why it is being skipped on
the right side of the <code>Ignore</code> attribute.</p>
<h3>Noncompliant code example</h3>
<pre>
[TestMethod]
[Ignore]
public void Test_DoTheThing()
{
  // ...
}
</pre>
<h3>Compliant solution</h3>
<pre>
[TestMethod]
[Ignore]  // renable when TCKT-1234 is fixed
public void Test_DoTheThing()
{
  // ...
}
</pre>
<p>or</p>
<pre>
[TestMethod]
[Ignore]
[WorkItem(1234)]
public void Test_DoTheThing()
{
  // ...
}
</pre>
<h3>Exceptions</h3>
<p>The rule doesn’t raise an issue if:</p>
<ul>
  <li> the test method is also marked with <code>WorkItem</code> attribute </li>
  <li> there is a comment on the right side of the <code>Ignore</code> attribute </li>
</ul>

