<h2>Why is this an issue?</h2>
<p>A chain of <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement">if/else
if</a> statements is evaluated from top to bottom. At most, only one branch will be executed: the first statement with a condition that evaluates to
<code>true</code>. Therefore, duplicating a condition leads to unreachable code inside the duplicated condition block. Usually, this is due to a
copy/paste error.</p>
<p>The result of such duplication can lead to unreachable code or even to unexpected behavior.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
if (param == 1)
{
  OpenWindow();
}
else if (param == 2)
{
  CloseWindow();
}
else if (param == 1) // Noncompliant: condition has already been checked
{
  MoveWindowToTheBackground(); // unreachable code
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
if (param == 1)
{
  OpenWindow();
}
else if (param == 2)
{
  CloseWindow();
}
else if (param == 3)
{
  MoveWindowToTheBackground();
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement">The if
  statement</a> </li>
</ul>

