<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate efficiently. This rule checks that all <code>enum</code> names match a provided regular
expression.</p>
<p>The default configuration is the one recommended by Microsoft:</p>
<ul>
  <li> Pascal casing, starting with an upper case character, e.g. BackColor </li>
  <li> Short abbreviations of 2 letters can be capitalized, e.g. GetID </li>
  <li> Longer abbreviations need to be lower case, e.g. GetHtml </li>
  <li> If the enum is marked as [Flags] then its name should be plural (e.g. MyOptions), otherwise, names should be singular (e.g. MyOption) </li>
</ul>
<h3>Noncompliant code example</h3>
<p>With the default regular expression for non-flags enums: <code>^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$</code></p>
<pre>
public enum foo // Noncompliant
{
    FooValue = 0
}
</pre>
<p>With the default regular expression for flags enums: <code>^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?s$</code></p>
<pre>
[Flags]
public enum Option // Noncompliant
{
    None = 0,
    Option1 = 1,
    Option2 = 2
}
</pre>
<h3>Compliant solution</h3>
<pre>
public enum Foo
{
    FooValue = 0
}
</pre>
<pre>
[Flags]
public enum Options
{
    None = 0,
    Option1 = 1,
    Option2 = 2
}
</pre>

