<h2>Why is this an issue?</h2>
<p>Property getters should be simple operations that are always safe to call. If exceptions need to be thrown, it is best to convert the property to a
method.</p>
<p>It is valid to throw exceptions from indexed property getters and from property setters, which are not detected by this rule.</p>
<h3>Noncompliant code example</h3>
<pre>
public int Foo
{
    get
    {
        throw new Exception(); // Noncompliant
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
public int Foo
{
    get
    {
        return 42;
    }
}
</pre>
<h3>Exceptions</h3>
<p>No issue is raised when the thrown exception derives from or is of type <code>NotImplementedException</code>, <code>NotSupportedException</code> or
<code>InvalidOperationException</code>.</p>

