<h2>Why is this an issue?</h2>
<p>When the same condition is checked twice in a row, it is either confusing - why have separate checks? - or an error - some other condition should
have been checked in the second test.</p>
<h3>Noncompliant code example</h3>
<pre>
if (a == b)
{
  doTheThing(b);
}
if (a == b) // Noncompliant; is this really what was intended?
{
  doTheThing(c);
}
</pre>
<h3>Compliant solution</h3>
<pre>
if (a == b)
{
  doTheThing(b);
  doTheThing(c);
}
</pre>
<p>or</p>
<pre>
if (a == b)
{
  doTheThing(b);
}
if (b == c)
{
  doTheThing(c);
}
</pre>
<h3>Exceptions</h3>
<p>Since it is a common pattern to test a variable, reassign it if it fails the test, then re-test it, that pattern is ignored.</p>

