<h2>Why is this an issue?</h2>
<p><a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/enum">Enumerations</a> are commonly used to identify
distinct elements from a set of values.</p>
<p>However, they can also serve as <a href="https://en.wikipedia.org/wiki/Bit_field">bit flags</a>, enabling bitwise operations to combine multiple
elements within a single value.</p>
<pre>
// Saturday = 0b00100000, Sunday = 0b01000000, weekend = 0b01100000
var weekend = Days.Saturday | Days.Sunday;  // Combining elements
</pre>
<p>When enumerations are used as bit flags, it is considered <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/enum#enumeration-types-as-bit-flags">good practice</a> to
annotate the enum type with the <a href="https://learn.microsoft.com/en-us/dotnet/api/system.flagsattribute">FlagsAttribute</a>:</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
enum Permissions
{
  None = 0,
  Read = 1,
  Write = 2,
  Execute = 4
}

// ...

var x = Permissions.Read | Permissions.Write;  // Noncompliant: enum is not annotated with [Flags]
</pre>
<p>The <code>FlagsAttribute</code> explicitly marks an enumeration as bit flags, making it clear that it uses bit fields and is intended to be used as
flags.</p>
<pre data-diff-id="1" data-diff-type="compliant">
[Flags]
enum Permissions
{
  None = 0,
  Read = 1,
  Write = 2,
  Execute = 4
}

// ...

var x = Permissions.Read | Permissions.Write;  // Compliant: enum is annotated with [Flags]
</pre>
<p>Additionally, adding the <code>FlagsAttribute</code> to the enumeration enable a <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.flagsattribute#examples">better string representation</a> when using the <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.enum.tostring">Enum.ToString</a> method.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/enum">Enumeration in C#</a>
    <ul>
      <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/enum#enumeration-types-as-bit-flags">Enumeration
      types as bit flags</a> </li>
    </ul>  </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.flagsattribute">FlagsAttribute class</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.enum.tostring">Enum.ToString method</a> </li>
  <li> <a href="https://en.wikipedia.org/wiki/Bit_field">Bit field - Wikipedia</a> </li>
</ul>

