<p>When a cookie is configured with the <code>HttpOnly</code> attribute set to <em>true</em>, the browser guaranties that no client-side script will
be able to read it. In most cases, when a cookie is created, the default value of <code>HttpOnly</code> is <em>false</em> and it’s up to the developer
to decide whether or not the content of the cookie can be read by the client-side script. As a majority of Cross-Site Scripting (XSS) attacks target
the theft of session-cookies, the <code>HttpOnly</code> attribute can help to reduce their impact as it won’t be possible to exploit the XSS
vulnerability to steal session-cookies.</p>
<h2>Ask Yourself Whether</h2>
<ul>
  <li> the cookie is sensitive, used to authenticate the user, for instance a <em>session-cookie</em> </li>
  <li> the <code>HttpOnly</code> attribute offer an additional protection (not the case for an <em>XSRF-TOKEN cookie</em> / CSRF token for example)
  </li>
</ul>
<p>There is a risk if you answered yes to any of those questions.</p>
<h2>Recommended Secure Coding Practices</h2>
<ul>
  <li> By default the <code>HttpOnly</code> flag should be set to <em>true</em> for most of the cookies and it’s mandatory for session /
  sensitive-security cookies. </li>
</ul>
<h2>Sensitive Code Example</h2>
<p>When the <code>HttpCookie.HttpOnly</code> property is set to <code>false</code> then the cookie can be accessed by client side code:</p>
<pre>
HttpCookie myCookie = new HttpCookie("Sensitive cookie");
myCookie.HttpOnly = false; // Sensitive: this cookie is created with the httponly flag set to false and so it can be stolen easily in case of XSS vulnerability
</pre>
<p>The <a href="https://docs.microsoft.com/en-us/dotnet/api/system.web.httpcookie.httponly?view=netframework-4.8">default value</a> of
<code>HttpOnly</code> flag is <code>false</code>, unless overwritten by an application’s configuration file:</p>
<pre>
HttpCookie myCookie = new HttpCookie("Sensitive cookie");
// Sensitive: this cookie is created without the httponly flag  (by default set to false) and so it can be stolen easily in case of XSS vulnerability
</pre>
<h2>Compliant Solution</h2>
<p>Set the <code>HttpCookie.HttpOnly</code> property to <code>true</code>:</p>
<pre>
HttpCookie myCookie = new HttpCookie("Sensitive cookie");
myCookie.HttpOnly = true; // Compliant: the sensitive cookie is protected against theft thanks to the HttpOnly property set to true (HttpOnly = true)
</pre>
<p>Or change the default flag values for the whole application by editing the <a
href="https://docs.microsoft.com/en-us/previous-versions/dotnet/netframework-4.0/ms228262(v=vs.100)">Web.config configuration file</a>:</p>
<pre>
&lt;httpCookies httpOnlyCookies="true" requireSSL="true" /&gt;
</pre>
<ul>
  <li> the <code>requireSSL</code> attribute corresponds programmatically to the <code>Secure</code> field. </li>
  <li> the <code>httpOnlyCookies</code> attribute corresponds programmatically to the <code>httpOnly</code> field. </li>
</ul>
<h2>See</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 Category A5 - Security Misconfiguration</a> </li>
  <li> <a href="https://owasp.org/www-community/HttpOnly">OWASP HttpOnly</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A7_2017-Cross-Site_Scripting_(XSS)">Top 10 2017 Category A7 - Cross-Site Scripting
  (XSS)</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/1004">CWE-1004 - Sensitive Cookie Without 'HttpOnly' Flag</a> </li>
  <li> Derived from FindSecBugs rule <a href="https://find-sec-bugs.github.io/bugs.htm#HTTPONLY_COOKIE">HTTPONLY_COOKIE</a> </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222575">Application Security and
  Development: V-222575</a> - The application must set the HTTPOnly flag on session cookies. </li>
</ul>

