<h2>Why is this an issue?</h2>
<p>Marking a method with the <a href="https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.contracts.pureattribute"><code>Pure</code></a>
attribute indicates that the method doesn’t make any visible state changes. Therefore, a <code>Pure</code> method should return a result. Otherwise,
it indicates a no-operation call.</p>
<p>Using <code>Pure</code> on a <code>void</code> method is either by mistake or the method is not doing a meaningful task.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
class Person
{
  private int age;

  [Pure] // Noncompliant: The method makes a state change
  void ConfigureAge(int age) =&gt;
    this.age = age;
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
class Person
{
  private int age;

  void ConfigureAge(int age) =&gt;
    this.age = age;
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.contracts.pureattribute">PureAttribute Class</a>
  </li>
</ul>

