<h2>Why is this an issue?</h2>
<p>String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The <code>System.Uri</code>
class is a safe alternative and should be preferred. At minimum, an overload of the method taking a <code>System.Uri</code> as a parameter should be
provided in each class that contains a method with an apparent Uri passed as a <code>string</code>.</p>
<p>This rule raises issues when a method has a string parameter with a name containing "uri", "Uri", "urn", "Urn", "url" or "Url", and the type
doesn’t declare a corresponding overload taking an <code>System.Uri</code> parameter instead.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
   public class MyClass
   {

      public void FetchResource(string uriString) { } // Noncompliant
   }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
   public class MyClass
   {

      public void FetchResource(string uriString)
      {
          FetchResource(new Uri(uriString));
      }

      public void FetchResource(Uri uri) { }
   }
}
</pre>

