<h2>Why is this an issue?</h2>
<p>String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The <code>System.Uri</code>
class is a safe alternative and should be preferred.</p>
<p>This rule raises an issue when a property is a string type and its name contains "uri", "Uri", "urn", "Urn", "url" or "Url".</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
   public class MyClass
   {
      string myUri;

      public string MyUri // Noncompliant
      {
         get { return myURI; }
         set { myUri = value; }
      }
   }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
   public class MyClass
   {
      Uri myUri;

      public Uri MyUri
      {
         get { return myURI; }
         set { myUri = value; }
      }
   }
}
</pre>

